import { Component } from '@angular/core';
import { Platform } from 'ionic-angular';
import { StatusBar } from '@ionic-native/status-bar';
import { SplashScreen } from '@ionic-native/splash-screen';

import { TabsPage } from '../pages/tabs/tabs';
import { FCM } from '@ionic-native/fcm';
import { HTTP } from "@ionic-native/http";
import {NativeStorage} from "@ionic-native/native-storage";

@Component({
  templateUrl: 'app.html'
})
export class MyApp {
  rootPage:any = TabsPage;

  constructor(platform: Platform, statusBar: StatusBar, splashScreen: SplashScreen, public fcm: FCM, public http: HTTP, public nativeStorage: NativeStorage) {
    platform.ready().then(() => {
      // Okay, so the platform is ready and our plugins are available.
      // Here you can do any higher level native things you might need.
      statusBar.styleDefault();
      splashScreen.hide();
      fcm.onNotification().subscribe( (data) => {
        console.log(data);
        if(!data.wasTapped){

        }
      });
      fcm.onTokenRefresh().subscribe((token)=>{
        //Do token refresh shit here
        this.nativeStorage.getItem("de.socify.push.TOKENS").then((data)=>{
          let accessToken = data['access_token'];
          let id = data['device_id'];
          let userID = data['user_id'];
          let payload = {
            device: {
              notify_key: token,
              device_token: accessToken,
              id: id
            },
            user: {
              id: userID,
            },
          };
          this.http.acceptAllCerts(false);
          this.http.enableSSLPinning(true);
          this.http.setDataSerializer('json');
          this.http.post("https://push.socify-lite.de/registerDevice", payload, null).then(
            (res)=>{
              let accessToken = res.data.access_token;
              let device_id = res.data.id;
              this.nativeStorage.setItem('de.socify.push.TOKENS', {access_token: accessToken, device_id: device_id, user_id: userID});
            }
          )
        });
      });
    });
  }
}
