import {Component, ViewChild} from '@angular/core';
import {ItemSliding, NavController, Refresher} from 'ionic-angular';
import {ToastController} from "ionic-angular";
import {AlertController} from "ionic-angular";
import {ScannerPage} from "../scanner/scanner";
import {HTTP} from '@ionic-native/http';
import {Platform} from "ionic-angular";
import {NativeStorage} from "@ionic-native/native-storage";
import {InAppBrowser} from "@ionic-native/in-app-browser";

@Component({
  selector: 'page-home',
  templateUrl: 'home.html'
})
export class HomePage {

  @ViewChild(Refresher) refresherView: Refresher;
  notifications: any;
  registered: boolean = false;

  constructor(public platform: Platform, public navCtrl: NavController, public alertCtrl: AlertController, public toastCtrl: ToastController, public http: HTTP, public nativeStorage: NativeStorage) {
    this.notifications = [
      {
        pageImg: "data:image/gif;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs="/*base64 encoded blank gif*/,
        pageName: "Keine Nachrichten!",
        content: "Du hast leider noch keine Nachrichten"
      }
    ];
  }

  ionViewWillEnter() {
    this.platform.ready().then(() => {
      if (this.platform.is('cordova')) {
        this.platform.resume.subscribe(() => {
          this.platform.ready().then(() => {
            this.refresherView._beginRefresh();
            this.nativeStorage.getItem("de.socify.push.TOKENS").then((data) => {
              let accessToken = data['access_token'];
              let id = data['device_id'];
              let userID = data['user_id'];
              this.notifications = data['notifications'];
              let payload = {
                device: {
                  token: accessToken,
                  id: id
                },
                user: {
                  id: userID,
                },
              };
              if (!accessToken || !id || !userID) {
                this.notifications = [
                  {
                    pageImg: "data:image/gif;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs=",
                    pageName: "Bitte melde dich an!",
                    content: "Tippe auf \"+\" um die App mit Socify zu verbinden. Bitte den QR code in deiner Socify-Instanz innerhalb deines Benutzerprofils aktivieren und mit der Kamera dieses Smartphones scannen."

                  }
                ];
                this.registered = false;
                this.refresherView.cancel();
                return;
              }
              this.notifications = data['notifications'];
              this.http.acceptAllCerts(false);
              this.http.enableSSLPinning(true);
              this.http.setDataSerializer('json');
              this.http.post("https://push.socify.de/getUserMessages", payload, null).then(
                (res) => {
                  let d = JSON.parse(res.data);
                  if (d.error) {
                    this.notifications = [
                      {
                        pageImg: "data:image/gif;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs=",
                        pageName: "Bitte melde dich an!",
                        content: "Tippe auf \"+\" um die App mit Socify zu verbinden. Bitte den QR code in deiner Socify-Instanz innerhalb deines Benutzerprofils aktivieren und mit der Kamera dieses Smartphones scannen."
                      }
                    ];
                    this.registered = false;
                    this.refresherView.cancel();
                    return;
                  }
                  if (d.length > 0) this.notifications = [];
                  console.log(d);
                  for (let message of d) {
                    console.log(message);
                    let m = {
                      pageImg: "https://graph.facebook.com/v3.1/" + message['page_id'] + "/picture?size=large",
                      pageName: message['page_name'],
                      content: message['text'],
                      url: message['url'],
                      id: message['id'],
                    };
                    this.notifications.push(m);
                  }
                  this.nativeStorage.setItem("de.socify.push.TOKENS", {
                    notifications: this.notifications,
                    access_token: accessToken,
                    device_id: id,
                    user_id: userID
                  });
                  this.registered = true;
                  this.refresherView.cancel();
                },
                (err) => {
                  let notTemp = this.notifications;
                  this.notifications = [
                    {
                      pageImg: "data:image/gif;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs=",
                      pageName: "Netzwerkfehler!",
                      content: "Bitte stelle sicher, dass eine Internetverbindung vorhanden ist!"

                    }
                  ];
                  for (let notification of notTemp) {
                    this.notifications.push(notification);
                  }
                  this.refresherView.cancel();
                }
              )
            }, (err) => {
              this.notifications = [
                {
                  pageImg: "data:image/gif;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs=",
                  pageName: "Bitte melde dich an!",
                  content: "Tippe auf \"+\" um die App mit Socify zu verbinden. Bitte den QR code in deiner Socify-Instanz innerhalb deines Benutzerprofils aktivieren und mit der Kamera dieses Smartphones scannen."

                }
              ];
              this.registered = false;
              this.refresherView.cancel();
            });
          });
        });
      }
      this.nativeStorage.getItem("de.socify.push.TOKENS").then((data) => {
        let accessToken = data['access_token'];
        let id = data['device_id'];
        let userID = data['user_id'];
        this.notifications = data['notifications'];
        let payload = {
          device: {
            token: accessToken,
            id: id
          },
          user: {
            id: userID,
          },
        };
        if (!accessToken || !id || !userID) {
          this.notifications = [
            {
              pageImg: "data:image/gif;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs=",
              pageName: "Bitte melde dich an!",
              content: "Tippe auf \"+\" um die App mit Socify zu verbinden. Bitte den QR code in deiner Socify-Instanz innerhalb deines Benutzerprofils aktivieren und mit der Kamera dieses Smartphones scannen."

            }
          ];
          this.registered = false;
          return;
        }
        this.notifications = data['notifications'];
        this.http.acceptAllCerts(false);
        this.http.enableSSLPinning(true);
        this.http.setDataSerializer('json');
        this.http.post("https://push.socify.de/getUserMessages", payload, null).then(
          (res) => {
            let d = JSON.parse(res.data);
            if (d.error) {
              this.notifications = [
                {
                  pageImg: "data:image/gif;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs=",
                  pageName: "Bitte melde dich an!",
                  content: "Tippe auf \"+\" um die App mit Socify zu verbinden. Bitte den QR code in deiner Socify-Instanz innerhalb deines Benutzerprofils aktivieren und mit der Kamera dieses Smartphones scannen."
                }
              ];
              this.registered = false;
              return;
            }
            if (d.length > 0) this.notifications = [];
            console.log(d);
            for (let message of d) {
              console.log(message);
              let m = {
                pageImg: "https://graph.facebook.com/v3.1/" + message['page_id'] + "/picture?size=large",
                pageName: message['page_name'],
                content: message['text'],
                url: message['url'],
                id: message['id'],
              };
              this.notifications.push(m);
            }
            this.registered = true;
            this.nativeStorage.setItem("de.socify.push.TOKENS", {
              notifications: this.notifications,
              access_token: accessToken,
              device_id: id,
              user_id: userID
            });
          },
          (err) => {
            let notTemp = this.notifications;
            this.notifications = [
              {
                pageImg: "data:image/gif;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs=",
                pageName: "Netzwerkfehler!",
                content: "Bitte stelle sicher, dass eine Internetverbindung vorhanden ist!"

              }
            ];
            for (let notification of notTemp) {
              this.notifications.push(notification);
            }
          }
        )
      }, (err) => {
        this.notifications = [
          {
            pageImg: "data:image/gif;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs=",
            pageName: "Bitte melde dich an!",
            content: "Tippe auf \"+\" um die App mit Socify zu verbinden. Bitte den QR code in deiner Socify-Instanz innerhalb deines Benutzerprofils aktivieren und mit der Kamera dieses Smartphones scannen."

          }
        ];
        this.registered = false;
      });
    });
  }

  hideCamera() {
    (window.document.querySelector('ion-app') as HTMLElement).classList.remove('cameraView');
  }

  ionViewDidEnter() {
    this.hideCamera();
  }

  linkPage() {
    this.navCtrl.push(ScannerPage).then(() => {
      this.platform.ready().then(() => {
        this.refresherView._beginRefresh();
        this.nativeStorage.getItem("de.socify.push.TOKENS").then((data) => {
          let accessToken = data['access_token'];
          let id = data['device_id'];
          let userID = data['user_id'];
          this.notifications = data['notifications'];
          let payload = {
            device: {
              token: accessToken,
              id: id
            },
            user: {
              id: userID,
            },
          };
          if (!accessToken || !id || !userID) {
            this.notifications = [
              {
                pageImg: "data:image/gif;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs=",
                pageName: "Bitte melde dich an!",
                content: "Tippe auf \"+\" um die App mit Socify zu verbinden. Bitte den QR code in deiner Socify-Instanz innerhalb deines Benutzerprofils aktivieren und mit der Kamera dieses Smartphones scannen."

              }
            ];
            this.registered = false;
            this.refresherView.cancel();
            return;
          }
          this.notifications = data['notifications'];
          this.http.acceptAllCerts(false);
          this.http.enableSSLPinning(true);
          this.http.setDataSerializer('json');
          this.http.post("https://push.socify.de/getUserMessages", payload, null).then(
            (res) => {
              let d = JSON.parse(res.data);
              if (d.error) {
                this.notifications = [
                  {
                    pageImg: "data:image/gif;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs=",
                    pageName: "Bitte melde dich an!",
                    content: "Tippe auf \"+\" um die App mit Socify zu verbinden. Bitte den QR code in deiner Socify-Instanz innerhalb deines Benutzerprofils aktivieren und mit der Kamera dieses Smartphones scannen."
                  }
                ];
                this.registered = false;
                this.refresherView.cancel();
                return;
              }
              if (d.length > 0) this.notifications = [];
              console.log(d);
              for (let message of d) {
                console.log(message);
                let m = {
                  pageImg: "https://graph.facebook.com/v3.1/" + message['page_id'] + "/picture?size=large",
                  pageName: message['page_name'],
                  content: message['text'],
                  url: message['url'],
                  id: message['id'],
                };
                this.notifications.push(m);
              }
              this.nativeStorage.setItem("de.socify.push.TOKENS", {
                notifications: this.notifications,
                access_token: accessToken,
                device_id: id,
                user_id: userID
              });
              this.registered = true;
              this.refresherView.cancel();
            },
            (err) => {
              let notTemp = this.notifications;
              this.notifications = [
                {
                  pageImg: "data:image/gif;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs=",
                  pageName: "Netzwerkfehler!",
                  content: "Bitte stelle sicher, dass eine Internetverbindung vorhanden ist!"

                }
              ];
              for (let notification of notTemp) {
                this.notifications.push(notification);
              }
              this.refresherView.cancel();
            }
          )
        }, (err) => {
          this.notifications = [
            {
              pageImg: "data:image/gif;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs=",
              pageName: "Bitte melde dich an!",
              content: "Tippe auf \"+\" um die App mit Socify zu verbinden. Bitte den QR code in deiner Socify-Instanz innerhalb deines Benutzerprofils aktivieren und mit der Kamera dieses Smartphones scannen."

            }
          ];
          this.registered = false;
          this.refresherView.cancel();
        });
      });

    });
  }

  refresh(refresher: any) {
    this.nativeStorage.getItem("de.socify.push.TOKENS").then((data) => {
      let accessToken = data['access_token'];
      let id = data['device_id'];
      let userID = data['user_id'];
      let payload = {
        device: {
          token: accessToken,
          id: id
        },
        user: {
          id: userID,
        },
      };
      if (!accessToken || !id || !userID) {
        this.notifications = [
          {
            pageImg: "data:image/gif;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs=",
            pageName: "Bitte melde dich an!",
            content: "Tippe auf \"+\" um die App mit Socify zu verbinden. Bitte den QR code in deiner Socify-Instanz innerhalb deines Benutzerprofils aktivieren und mit der Kamera dieses Smartphones scannen."

          }
        ];
        refresher.complete();
        return;
      }
      this.notifications = data['notifications'];
      this.http.acceptAllCerts(false);
      this.http.enableSSLPinning(true);
      this.http.setDataSerializer('json');
      this.http.post("https://push.socify.de/getUserMessages", payload, null).then(
        (res) => {
          let d = JSON.parse(res.data);
          if (d.error) {
            this.notifications = [
              {
                pageImg: "data:image/gif;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs=",
                pageName: "Bitte melde dich an!",
                content: "Tippe auf \"+\" um die App mit Socify zu verbinden. Bitte den QR code in deiner Socify-Instanz innerhalb deines Benutzerprofils aktivieren und mit der Kamera dieses Smartphones scannen."
              }
            ];
            this.registered = false;
            refresher.complete();
            return;
          }
          this.notifications = [];
          console.log(d);
          for (let message of d) {
            console.log(message);
            let m = {
              pageImg: "https://graph.facebook.com/v3.1/" + message['page_id'] + "/picture?size=large",
              pageName: message['page_name'],
              content: message['text'],
              url: message['url'],
              id: message['id'],
            };
            this.notifications.push(m);
          }
          refresher.complete();
          this.nativeStorage.setItem("de.socify.push.TOKENS", {
            notifications: this.notifications,
            access_token: accessToken,
            device_id: id,
            user_id: userID
          });
          this.registered = true;
        },
        (err) => {
          let notTemp = this.notifications;
          this.notifications = [
            {
              pageImg: "data:image/gif;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs=",
              pageName: "Netzwerkfehler!",
              content: "Bitte stelle sicher, dass eine Internetverbindung vorhanden ist!"

            }
          ];
          for (let notification of notTemp) {
            this.notifications.push(notification);
          }
          refresher.complete();
        }
      )
    }, (err) => {
      this.notifications = [
        {
          pageImg: "data:image/gif;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs=",
          pageName: "Bitte melde dich an!",
          content: "Tippe auf \"+\" um die App mit Socify zu verbinden. Bitte den QR code in deiner Socify-Instanz innerhalb deines Benutzerprofils aktivieren und mit der Kamera dieses Smartphones scannen."
        }
      ];
      this.registered = false;
    });
  }

  itemClick(item: any) {
    if (item.url)
      new InAppBrowser().create(item.url, '_system');
  }

  archive(item: any,slidingItem: ItemSliding) {
    if (item.id) {
      this.nativeStorage.getItem("de.socify.push.TOKENS").then((data) => {
        let accessToken = data['access_token'];
        let id = data['device_id'];
        let userID = data['user_id'];
        let payload = {
          device: {
            token: accessToken,
            id: id
          },
          user: {
            id: userID,
          },
          message: {
            id: item.id,
          }
        };
        this.http.acceptAllCerts(false);
        this.http.enableSSLPinning(true);
        this.http.setDataSerializer('json');
        this.http.post("https://push.socify.de/markAsRead", payload, null).then(
          (res) => {
            let d = JSON.parse(res.data);
            console.log('archive: ' + res.data);
            for (let i = 0; i < this.notifications.length; i++) {

              if (this.notifications[i] == item) {
                console.log('found item!');
                slidingItem.close();
                this.notifications.splice(i, 1);
              }
            }
          }
        )
      });
    }
  }

}
