import { Component } from '@angular/core';
import {NavController, Platform} from 'ionic-angular';
import { ToastController } from "ionic-angular";
import { QRScanner, QRScannerStatus } from "@ionic-native/qr-scanner";
import { AlertController} from "ionic-angular";
import { FCM } from "@ionic-native/fcm";
import { HTTP } from "@ionic-native/http";
import { Device } from "@ionic-native/device";
import {NativeStorage} from "@ionic-native/native-storage";

@Component({
  selector: 'page-scanner',
  templateUrl: 'scanner.html'
})
export class ScannerPage {


  constructor(public platform: Platform, public navCtrl: NavController, public alertCtrl: AlertController, public qrScanner: QRScanner, public toastCtrl: ToastController, public http: HTTP, public fcm: FCM, public device: Device, public nativeStorage: NativeStorage) {
    this.linkPage();

  }

  showCamera() {
    console.log("SHOW CAMERA");
    (window.document.querySelector('ion-app')).classList.add('cameraView');
  }

  hideCamera() {
    console.log("HIDE CAMERA");
    (window.document.querySelector('ion-app')).classList.remove('cameraView');
  }

  ionViewDidEnter(){
    this.showCamera();
  }
  ionViewWillLeave(){
    this.hideCamera();
  }

  linkPage(){

    this.qrScanner.prepare()
      .then((status: QRScannerStatus) => {
        if(status.authorized){
          this.showCamera();
          /*this.toastCtrl.create({
            message: 'SCANNER AUTHORIZED',
            duration: 3000,
            position: 'top'
          }).present();*/
          let scanSub = this.qrScanner.scan().subscribe((text: string) => {
            console.log('SCANNED SOMETHING: ', atob(text));

            let decoded = atob(text);
            let decodedArr = decoded.split('-');
            this.fcm.getToken().then((token)=>{
                let payload = {
                  device: {
                    name: this.device.manufacturer + " " + this.device.model + "(" + this.device.serial + "; " + this.device.platform + "-" + this.device.version + ")",
                    notify_key: token,
                  },
                  user: {
                    id: decodedArr[0],
                  },
                  code: decodedArr[1],
                };
                console.log(payload);
                this.http.acceptAllCerts(false);
                this.http.enableSSLPinning(true);
                this.http.setDataSerializer('json');
                this.http.post("https://push.socify.de/registerDevice", payload, null).then(
                  (response)=>{
                    console.log(response);
                    let data = JSON.parse(response.data);
                    let accessToken = data.access_token;
                    let device_id = data.id;
                    this.nativeStorage.setItem('de.socify.push.TOKENS', {access_token: accessToken, device_id: device_id, user_id: decodedArr[0], notifications: []});
                    this.toastCtrl.create({
                      message: 'Registrierung erfolgreich!',
                      duration: 3000,
                      position: 'top'
                    }).present();
                    this.navCtrl.pop();
                  }
                ).catch((error)=>{
                  console.log(error);
                  this.toastCtrl.create({
                    message: 'Fehler bei Gerätregistrierung!',
                    duration: 3000,
                    position: 'top'
                  }).present();
                });

              }
            ).catch((error)=>{
              console.log(error);
              /*this.toastCtrl.create({
                message: 'Error retrieving FCM Token',
                duration: 3000,
                position: 'top'
              }).present();*/
              });
            /*this.toastCtrl.create({
              message: 'SCANNED: ' + text,
              duration: 3000,
              position: 'top'
            }).present();*/
            this.qrScanner.hide();
            this.hideCamera();
            scanSub.unsubscribe();

          });
          this.qrScanner.show()
            .then((status: QRScannerStatus)=>{
              /*this.toastCtrl.create({
                message: 'SCANNER SHOW OK',
                duration: 3000,
                position: 'top'
              }).present();*/
            })
            .catch((e: any)=>{
              /*this.toastCtrl.create({
                message: 'SCANNER SHOW ERROR!: ' + e,
                duration: 3000,
                position: 'top'
              }).present();*/
            });
        }else if(status.denied){
          this.alertCtrl.create({
            title: "Fehlende Berechtigung!",
            message: 'Bitte erlaube die Benutzung der Kamera durch die App in den Einstellungen, sonst kannst du dein Gerät leider nicht verbinden!',
            buttons: [
              {
                text: 'Abbrechen',
                role: 'cancel',
                handler: ()=>{

                }
              },
              {
                text: 'Einstellungen öffnen',
                handler: ()=>{
                  this.qrScanner.openSettings();
                }
              }
            ]
          }).present();
        }else{
          this.toastCtrl.create({
            message: "Bitte erlaube die Benutzung der Kamera um das Gerät zu verbinden!",
            duration: 3000,
            position: 'top'
          }).present();
          this.qrScanner.hide();
        }

      })
      .catch( (e: any) => console.log('Error in QR: ', e));

    /*let toast = this.toastCtrl.create({
      message: "PAGE LINK CLICKED",
      duration: 1500,
      position: 'top'
    });
    toast.present();*/
  }

}
