webpackJsonp([0],{

/***/ 102:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return ScannerPage; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_core__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_ionic_angular__ = __webpack_require__(15);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__ionic_native_qr_scanner__ = __webpack_require__(199);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__ionic_native_fcm__ = __webpack_require__(103);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__ionic_native_http__ = __webpack_require__(41);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5__ionic_native_device__ = __webpack_require__(200);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6__ionic_native_native_storage__ = __webpack_require__(42);
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};









var ScannerPage = /** @class */ (function () {
    function ScannerPage(platform, navCtrl, alertCtrl, qrScanner, toastCtrl, http, fcm, device, nativeStorage) {
        this.platform = platform;
        this.navCtrl = navCtrl;
        this.alertCtrl = alertCtrl;
        this.qrScanner = qrScanner;
        this.toastCtrl = toastCtrl;
        this.http = http;
        this.fcm = fcm;
        this.device = device;
        this.nativeStorage = nativeStorage;
        this.linkPage();
    }
    ScannerPage.prototype.showCamera = function () {
        console.log("SHOW CAMERA");
        (window.document.querySelector('ion-app')).classList.add('cameraView');
    };
    ScannerPage.prototype.hideCamera = function () {
        console.log("HIDE CAMERA");
        (window.document.querySelector('ion-app')).classList.remove('cameraView');
    };
    ScannerPage.prototype.ionViewDidEnter = function () {
        this.showCamera();
    };
    ScannerPage.prototype.ionViewWillLeave = function () {
        this.hideCamera();
    };
    ScannerPage.prototype.linkPage = function () {
        var _this = this;
        this.qrScanner.prepare()
            .then(function (status) {
            if (status.authorized) {
                _this.showCamera();
                /*this.toastCtrl.create({
                  message: 'SCANNER AUTHORIZED',
                  duration: 3000,
                  position: 'top'
                }).present();*/
                var scanSub_1 = _this.qrScanner.scan().subscribe(function (text) {
                    console.log('SCANNED SOMETHING: ', atob(text));
                    var decoded = atob(text);
                    var decodedArr = decoded.split('-');
                    _this.fcm.getToken().then(function (token) {
                        var payload = {
                            device: {
                                name: _this.device.manufacturer + " " + _this.device.model + "(" + _this.device.serial + "; " + _this.device.platform + "-" + _this.device.version + ")",
                                notify_key: token,
                            },
                            user: {
                                id: decodedArr[0],
                            },
                            code: decodedArr[1],
                        };
                        console.log(payload);
                        _this.http.acceptAllCerts(false);
                        _this.http.enableSSLPinning(true);
                        _this.http.setDataSerializer('json');
                        _this.http.post("https://push.socify.de/registerDevice", payload, null).then(function (response) {
                            console.log(response);
                            var data = JSON.parse(response.data);
                            var accessToken = data.access_token;
                            var device_id = data.id;
                            _this.nativeStorage.setItem('de.socify.push.TOKENS', { access_token: accessToken, device_id: device_id, user_id: decodedArr[0], notifications: [] });
                            _this.toastCtrl.create({
                                message: 'Registrierung erfolgreich!',
                                duration: 3000,
                                position: 'top'
                            }).present();
                            _this.navCtrl.pop();
                        }).catch(function (error) {
                            console.log(error);
                            _this.toastCtrl.create({
                                message: 'Fehler bei Gerätregistrierung!',
                                duration: 3000,
                                position: 'top'
                            }).present();
                        });
                    }).catch(function (error) {
                        console.log(error);
                        /*this.toastCtrl.create({
                          message: 'Error retrieving FCM Token',
                          duration: 3000,
                          position: 'top'
                        }).present();*/
                    });
                    /*this.toastCtrl.create({
                      message: 'SCANNED: ' + text,
                      duration: 3000,
                      position: 'top'
                    }).present();*/
                    _this.qrScanner.hide();
                    _this.hideCamera();
                    scanSub_1.unsubscribe();
                });
                _this.qrScanner.show()
                    .then(function (status) {
                    /*this.toastCtrl.create({
                      message: 'SCANNER SHOW OK',
                      duration: 3000,
                      position: 'top'
                    }).present();*/
                })
                    .catch(function (e) {
                    /*this.toastCtrl.create({
                      message: 'SCANNER SHOW ERROR!: ' + e,
                      duration: 3000,
                      position: 'top'
                    }).present();*/
                });
            }
            else if (status.denied) {
                _this.alertCtrl.create({
                    title: "Fehlende Berechtigung!",
                    message: 'Bitte erlaube die Benutzung der Kamera durch die App in den Einstellungen, sonst kannst du dein Gerät leider nicht verbinden!',
                    buttons: [
                        {
                            text: 'Abbrechen',
                            role: 'cancel',
                            handler: function () {
                            }
                        },
                        {
                            text: 'Einstellungen öffnen',
                            handler: function () {
                                _this.qrScanner.openSettings();
                            }
                        }
                    ]
                }).present();
            }
            else {
                _this.toastCtrl.create({
                    message: "Bitte erlaube die Benutzung der Kamera um das Gerät zu verbinden!",
                    duration: 3000,
                    position: 'top'
                }).present();
                _this.qrScanner.hide();
            }
        })
            .catch(function (e) { return console.log('Error in QR: ', e); });
        /*let toast = this.toastCtrl.create({
          message: "PAGE LINK CLICKED",
          duration: 1500,
          position: 'top'
        });
        toast.present();*/
    };
    ScannerPage = __decorate([
        Object(__WEBPACK_IMPORTED_MODULE_0__angular_core__["m" /* Component */])({
            selector: 'page-scanner',template:/*ion-inline-start:"C:\Users\fabia\Documents\Programmieren\Socify-Push\socify-push-app\SocifyPush\src\pages\scanner\scanner.html"*/'<ion-header>\n  <ion-navbar>\n    <ion-title>Home</ion-title>\n  </ion-navbar>\n</ion-header>\n\n<ion-content style="background: none transparent;" padding>\n</ion-content>\n'/*ion-inline-end:"C:\Users\fabia\Documents\Programmieren\Socify-Push\socify-push-app\SocifyPush\src\pages\scanner\scanner.html"*/
        }),
        __metadata("design:paramtypes", [__WEBPACK_IMPORTED_MODULE_1_ionic_angular__["f" /* Platform */], __WEBPACK_IMPORTED_MODULE_1_ionic_angular__["e" /* NavController */], __WEBPACK_IMPORTED_MODULE_1_ionic_angular__["a" /* AlertController */], __WEBPACK_IMPORTED_MODULE_2__ionic_native_qr_scanner__["a" /* QRScanner */], __WEBPACK_IMPORTED_MODULE_1_ionic_angular__["h" /* ToastController */], __WEBPACK_IMPORTED_MODULE_4__ionic_native_http__["a" /* HTTP */], __WEBPACK_IMPORTED_MODULE_3__ionic_native_fcm__["a" /* FCM */], __WEBPACK_IMPORTED_MODULE_5__ionic_native_device__["a" /* Device */], __WEBPACK_IMPORTED_MODULE_6__ionic_native_native_storage__["a" /* NativeStorage */]])
    ], ScannerPage);
    return ScannerPage;
}());

//# sourceMappingURL=scanner.js.map

/***/ }),

/***/ 113:
/***/ (function(module, exports) {

function webpackEmptyAsyncContext(req) {
	// Here Promise.resolve().then() is used instead of new Promise() to prevent
	// uncatched exception popping up in devtools
	return Promise.resolve().then(function() {
		throw new Error("Cannot find module '" + req + "'.");
	});
}
webpackEmptyAsyncContext.keys = function() { return []; };
webpackEmptyAsyncContext.resolve = webpackEmptyAsyncContext;
module.exports = webpackEmptyAsyncContext;
webpackEmptyAsyncContext.id = 113;

/***/ }),

/***/ 154:
/***/ (function(module, exports) {

function webpackEmptyAsyncContext(req) {
	// Here Promise.resolve().then() is used instead of new Promise() to prevent
	// uncatched exception popping up in devtools
	return Promise.resolve().then(function() {
		throw new Error("Cannot find module '" + req + "'.");
	});
}
webpackEmptyAsyncContext.keys = function() { return []; };
webpackEmptyAsyncContext.resolve = webpackEmptyAsyncContext;
module.exports = webpackEmptyAsyncContext;
webpackEmptyAsyncContext.id = 154;

/***/ }),

/***/ 197:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return TabsPage; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_core__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__about_about__ = __webpack_require__(198);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__home_home__ = __webpack_require__(202);
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};



var TabsPage = /** @class */ (function () {
    function TabsPage() {
        this.tab1Root = __WEBPACK_IMPORTED_MODULE_2__home_home__["a" /* HomePage */];
        this.tab2Root = __WEBPACK_IMPORTED_MODULE_1__about_about__["a" /* AboutPage */];
    }
    TabsPage = __decorate([
        Object(__WEBPACK_IMPORTED_MODULE_0__angular_core__["m" /* Component */])({template:/*ion-inline-start:"C:\Users\fabia\Documents\Programmieren\Socify-Push\socify-push-app\SocifyPush\src\pages\tabs\tabs.html"*/'<ion-tabs>\n  <ion-tab [root]="tab1Root" tabTitle="Home" tabIcon="home"></ion-tab>\n  <ion-tab [root]="tab2Root" tabTitle="Archiv" tabIcon="archive"></ion-tab>\n</ion-tabs>\n'/*ion-inline-end:"C:\Users\fabia\Documents\Programmieren\Socify-Push\socify-push-app\SocifyPush\src\pages\tabs\tabs.html"*/
        }),
        __metadata("design:paramtypes", [])
    ], TabsPage);
    return TabsPage;
}());

//# sourceMappingURL=tabs.js.map

/***/ }),

/***/ 198:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return AboutPage; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_core__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_ionic_angular__ = __webpack_require__(15);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__ionic_native_http__ = __webpack_require__(41);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__ionic_native_native_storage__ = __webpack_require__(42);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__scanner_scanner__ = __webpack_require__(102);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5__ionic_native_in_app_browser__ = __webpack_require__(201);
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};






var AboutPage = /** @class */ (function () {
    function AboutPage(platform, navCtrl, alertCtrl, toastCtrl, http, nativeStorage) {
        this.platform = platform;
        this.navCtrl = navCtrl;
        this.alertCtrl = alertCtrl;
        this.toastCtrl = toastCtrl;
        this.http = http;
        this.nativeStorage = nativeStorage;
        this.registered = false;
        this.notifications = [
            {
                pageImg: "data:image/gif;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs=" /*base64 encoded blank gif*/,
                pageName: "Keine Nachrichten!",
                content: "Du hast leider noch keine Nachrichten"
            }
        ];
    }
    AboutPage.prototype.ionViewWillEnter = function () {
        var _this = this;
        this.platform.ready().then(function () {
            if (_this.platform.is('cordova')) {
                _this.platform.resume.subscribe(function () {
                    _this.platform.ready().then(function () {
                        _this.nativeStorage.getItem("de.socify.push.TOKENS").then(function (data) {
                            var accessToken = data['access_token'];
                            var id = data['device_id'];
                            var userID = data['user_id'];
                            _this.notifications = data['notifications'];
                            var payload = {
                                device: {
                                    token: accessToken,
                                    id: id
                                },
                                user: {
                                    id: userID,
                                },
                            };
                            if (!accessToken || !id || !userID) {
                                _this.notifications = [
                                    {
                                        pageImg: "data:image/gif;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs=",
                                        pageName: "Bitte melde dich an!",
                                        content: "Tippe auf \"+\" um die App mit Socify zu verbinden. Bitte den QR code in deiner Socify-Instanz innerhalb deines Benutzerprofils aktivieren und mit der Kamera dieses Smartphones scannen."
                                    }
                                ];
                                _this.registered = false;
                                return;
                            }
                            _this.notifications = data['notifications'];
                            _this.http.acceptAllCerts(false);
                            _this.http.enableSSLPinning(true);
                            _this.http.setDataSerializer('json');
                            _this.http.post("https://push.socify.de/getUserMessages", payload, null).then(function (res) {
                                var d = JSON.parse(res.data);
                                if (d.error) {
                                    _this.notifications = [
                                        {
                                            pageImg: "data:image/gif;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs=",
                                            pageName: "Bitte melde dich an!",
                                            content: "Tippe auf \"+\" um die App mit Socify zu verbinden. Bitte den QR code in deiner Socify-Instanz innerhalb deines Benutzerprofils aktivieren und mit der Kamera dieses Smartphones scannen."
                                        }
                                    ];
                                    _this.registered = false;
                                    return;
                                }
                                if (d.length > 0)
                                    _this.notifications = [];
                                console.log(d);
                                for (var _i = 0, d_1 = d; _i < d_1.length; _i++) {
                                    var message = d_1[_i];
                                    console.log(message);
                                    var m = {
                                        pageImg: "https://graph.facebook.com/v3.1/" + message['page_id'] + "/picture?size=large",
                                        pageName: message['page_name'],
                                        content: message['text'],
                                        url: message['url'],
                                        id: message['id'],
                                    };
                                    _this.notifications.push(m);
                                }
                                _this.nativeStorage.setItem("de.socify.push.TOKENS", {
                                    notifications: _this.notifications,
                                    access_token: accessToken,
                                    device_id: id,
                                    user_id: userID
                                });
                                _this.registered = true;
                            }, function (err) {
                                var notTemp = _this.notifications;
                                _this.notifications = [
                                    {
                                        pageImg: "data:image/gif;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs=",
                                        pageName: "Netzwerkfehler!",
                                        content: "Bitte stelle sicher, dass eine Internetverbindung vorhanden ist!"
                                    }
                                ];
                                for (var _i = 0, notTemp_1 = notTemp; _i < notTemp_1.length; _i++) {
                                    var notification = notTemp_1[_i];
                                    _this.notifications.push(notification);
                                }
                            });
                        }, function (err) {
                            _this.notifications = [
                                {
                                    pageImg: "data:image/gif;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs=",
                                    pageName: "Bitte melde dich an!",
                                    content: "Tippe auf \"+\" um die App mit Socify zu verbinden. Bitte den QR code in deiner Socify-Instanz innerhalb deines Benutzerprofils aktivieren und mit der Kamera dieses Smartphones scannen."
                                }
                            ];
                            _this.registered = false;
                        });
                    });
                });
            }
            _this.nativeStorage.getItem("de.socify.push.TOKENS").then(function (data) {
                var accessToken = data['access_token'];
                var id = data['device_id'];
                var userID = data['user_id'];
                _this.notifications = data['archive'];
                var payload = {
                    device: {
                        token: accessToken,
                        id: id
                    },
                    user: {
                        id: userID,
                    },
                };
                if (!accessToken || !id || !userID) {
                    _this.notifications = [
                        {
                            pageImg: "data:image/gif;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs=",
                            pageName: "Bitte melde dich an!",
                            content: "Tippe auf \"+\" um die App mit Socify zu verbinden. Bitte den QR code in deiner Socify-Instanz innerhalb deines Benutzerprofils aktivieren und mit der Kamera dieses Smartphones scannen."
                        }
                    ];
                    _this.registered = false;
                    return;
                }
                _this.notifications = data['archive'];
                _this.http.acceptAllCerts(false);
                _this.http.enableSSLPinning(true);
                _this.http.setDataSerializer('json');
                _this.http.post("https://push.socify.de/getReadUserMessages", payload, null).then(function (res) {
                    var d = JSON.parse(res.data);
                    if (d.error) {
                        _this.notifications = [
                            {
                                pageImg: "data:image/gif;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs=",
                                pageName: "Bitte melde dich an!",
                                content: "Tippe auf \"+\" um die App mit Socify zu verbinden. Bitte den QR code in deiner Socify-Instanz innerhalb deines Benutzerprofils aktivieren und mit der Kamera dieses Smartphones scannen."
                            }
                        ];
                        _this.registered = false;
                        return;
                    }
                    if (d.length > 0)
                        _this.notifications = [];
                    console.log(d);
                    for (var _i = 0, d_2 = d; _i < d_2.length; _i++) {
                        var message = d_2[_i];
                        console.log(message);
                        var m = {
                            pageImg: "https://graph.facebook.com/v3.1/" + message['page_id'] + "/picture?size=large",
                            pageName: message['page_name'],
                            content: message['text'],
                            url: message['url'],
                        };
                        _this.notifications.push(m);
                    }
                    _this.registered = true;
                    _this.nativeStorage.setItem("de.socify.push.TOKENS", {
                        archive: _this.notifications,
                        access_token: accessToken,
                        device_id: id,
                        user_id: userID
                    });
                }, function (err) {
                    var notTemp = _this.notifications;
                    _this.notifications = [
                        {
                            pageImg: "data:image/gif;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs=",
                            pageName: "Netzwerkfehler!",
                            content: "Bitte stelle sicher, dass eine Internetverbindung vorhanden ist!"
                        }
                    ];
                    for (var _i = 0, notTemp_2 = notTemp; _i < notTemp_2.length; _i++) {
                        var notification = notTemp_2[_i];
                        _this.notifications.push(notification);
                    }
                });
            }, function (err) {
                _this.notifications = [
                    {
                        pageImg: "data:image/gif;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs=",
                        pageName: "Bitte melde dich an!",
                        content: "Tippe auf \"+\" um die App mit Socify zu verbinden. Bitte den QR code in deiner Socify-Instanz innerhalb deines Benutzerprofils aktivieren und mit der Kamera dieses Smartphones scannen."
                    }
                ];
                _this.registered = false;
            });
        });
    };
    AboutPage.prototype.hideCamera = function () {
        window.document.querySelector('ion-app').classList.remove('cameraView');
    };
    AboutPage.prototype.ionViewDidEnter = function () {
        this.hideCamera();
    };
    AboutPage.prototype.linkPage = function () {
        var _this = this;
        this.navCtrl.push(__WEBPACK_IMPORTED_MODULE_4__scanner_scanner__["a" /* ScannerPage */]).then(function () {
            _this.platform.ready().then(function () {
                _this.nativeStorage.getItem("de.socify.push.TOKENS").then(function (data) {
                    var accessToken = data['access_token'];
                    var id = data['device_id'];
                    var userID = data['user_id'];
                    _this.notifications = data['archive'];
                    var payload = {
                        device: {
                            token: accessToken,
                            id: id
                        },
                        user: {
                            id: userID,
                        },
                    };
                    if (!accessToken || !id || !userID) {
                        _this.notifications = [
                            {
                                pageImg: "data:image/gif;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs=",
                                pageName: "Bitte melde dich an!",
                                content: "Tippe auf \"+\" um die App mit Socify zu verbinden. Bitte den QR code in deiner Socify-Instanz innerhalb deines Benutzerprofils aktivieren und mit der Kamera dieses Smartphones scannen."
                            }
                        ];
                        _this.registered = false;
                        return;
                    }
                    _this.notifications = data['archive'];
                    _this.http.acceptAllCerts(false);
                    _this.http.enableSSLPinning(true);
                    _this.http.setDataSerializer('json');
                    _this.http.post("https://push.socify.de/getReadUserMessages", payload, null).then(function (res) {
                        var d = JSON.parse(res.data);
                        if (d.error) {
                            _this.notifications = [
                                {
                                    pageImg: "data:image/gif;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs=",
                                    pageName: "Bitte melde dich an!",
                                    content: "Tippe auf \"+\" um die App mit Socify zu verbinden. Bitte den QR code in deiner Socify-Instanz innerhalb deines Benutzerprofils aktivieren und mit der Kamera dieses Smartphones scannen."
                                }
                            ];
                            _this.registered = false;
                            return;
                        }
                        if (d.length > 0)
                            _this.notifications = [];
                        console.log(d);
                        for (var _i = 0, d_3 = d; _i < d_3.length; _i++) {
                            var message = d_3[_i];
                            console.log(message);
                            var m = {
                                pageImg: "https://graph.facebook.com/v3.1/" + message['page_id'] + "/picture?size=large",
                                pageName: message['page_name'],
                                content: message['text'],
                                url: message['url'],
                            };
                            _this.notifications.push(m);
                        }
                        _this.nativeStorage.setItem("de.socify.push.TOKENS", {
                            archive: _this.notifications,
                            access_token: accessToken,
                            device_id: id,
                            user_id: userID
                        });
                        _this.registered = true;
                    }, function (err) {
                        var notTemp = _this.notifications;
                        _this.notifications = [
                            {
                                pageImg: "data:image/gif;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs=",
                                pageName: "Netzwerkfehler!",
                                content: "Bitte stelle sicher, dass eine Internetverbindung vorhanden ist!"
                            }
                        ];
                        for (var _i = 0, notTemp_3 = notTemp; _i < notTemp_3.length; _i++) {
                            var notification = notTemp_3[_i];
                            _this.notifications.push(notification);
                        }
                    });
                }, function (err) {
                    _this.notifications = [
                        {
                            pageImg: "data:image/gif;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs=",
                            pageName: "Bitte melde dich an!",
                            content: "Tippe auf \"+\" um die App mit Socify zu verbinden. Bitte den QR code in deiner Socify-Instanz innerhalb deines Benutzerprofils aktivieren und mit der Kamera dieses Smartphones scannen."
                        }
                    ];
                    _this.registered = false;
                });
            });
        });
    };
    AboutPage.prototype.refresh = function (refresher) {
        var _this = this;
        this.nativeStorage.getItem("de.socify.push.TOKENS").then(function (data) {
            var accessToken = data['access_token'];
            var id = data['device_id'];
            var userID = data['user_id'];
            var payload = {
                device: {
                    token: accessToken,
                    id: id
                },
                user: {
                    id: userID,
                },
            };
            if (!accessToken || !id || !userID) {
                _this.notifications = [
                    {
                        pageImg: "data:image/gif;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs=",
                        pageName: "Bitte melde dich an!",
                        content: "Tippe auf \"+\" um die App mit Socify zu verbinden. Bitte den QR code in deiner Socify-Instanz innerhalb deines Benutzerprofils aktivieren und mit der Kamera dieses Smartphones scannen."
                    }
                ];
                refresher.complete();
                return;
            }
            _this.notifications = data['archive'];
            _this.http.acceptAllCerts(false);
            _this.http.enableSSLPinning(true);
            _this.http.setDataSerializer('json');
            _this.http.post("https://push.socify.de/getReadUserMessages", payload, null).then(function (res) {
                var d = JSON.parse(res.data);
                if (d.error) {
                    _this.notifications = [
                        {
                            pageImg: "data:image/gif;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs=",
                            pageName: "Bitte melde dich an!",
                            content: "Tippe auf \"+\" um die App mit Socify zu verbinden. Bitte den QR code in deiner Socify-Instanz innerhalb deines Benutzerprofils aktivieren und mit der Kamera dieses Smartphones scannen."
                        }
                    ];
                    _this.registered = false;
                    refresher.complete();
                    return;
                }
                _this.notifications = [];
                console.log(d);
                for (var _i = 0, d_4 = d; _i < d_4.length; _i++) {
                    var message = d_4[_i];
                    console.log(message);
                    var m = {
                        pageImg: "https://graph.facebook.com/v3.1/" + message['page_id'] + "/picture?size=large",
                        pageName: message['page_name'],
                        content: message['text'],
                        url: message['url'],
                    };
                    _this.notifications.push(m);
                }
                refresher.complete();
                _this.nativeStorage.setItem("de.socify.push.TOKENS", {
                    archive: _this.notifications,
                    access_token: accessToken,
                    device_id: id,
                    user_id: userID
                });
                _this.registered = true;
            }, function (err) {
                var notTemp = _this.notifications;
                _this.notifications = [
                    {
                        pageImg: "data:image/gif;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs=",
                        pageName: "Netzwerkfehler!",
                        content: "Bitte stelle sicher, dass eine Internetverbindung vorhanden ist!"
                    }
                ];
                for (var _i = 0, notTemp_4 = notTemp; _i < notTemp_4.length; _i++) {
                    var notification = notTemp_4[_i];
                    _this.notifications.push(notification);
                }
                refresher.complete();
            });
        }, function (err) {
            _this.notifications = [
                {
                    pageImg: "data:image/gif;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs=",
                    pageName: "Bitte melde dich an!",
                    content: "Tippe auf \"+\" um die App mit Socify zu verbinden. Bitte den QR code in deiner Socify-Instanz innerhalb deines Benutzerprofils aktivieren und mit der Kamera dieses Smartphones scannen."
                }
            ];
            _this.registered = false;
        });
    };
    AboutPage.prototype.itemClick = function (item) {
        if (item.url)
            new __WEBPACK_IMPORTED_MODULE_5__ionic_native_in_app_browser__["a" /* InAppBrowser */]().create(item.url, '_system');
    };
    AboutPage = __decorate([
        Object(__WEBPACK_IMPORTED_MODULE_0__angular_core__["m" /* Component */])({
            selector: 'page-about',template:/*ion-inline-start:"C:\Users\fabia\Documents\Programmieren\Socify-Push\socify-push-app\SocifyPush\src\pages\about\about.html"*/'<ion-header>\n  <ion-navbar>\n    <ion-title>Archiv</ion-title>\n  </ion-navbar>\n</ion-header>\n\n<ion-content padding>\n  <ion-refresher (ionRefresh)="refresh($event)">\n    <ion-refresher-content></ion-refresher-content>\n  </ion-refresher>\n  <h2>Archivierte Benachrichtigungen:</h2>\n  <ion-list>\n    <ion-item *ngFor="let item of notifications" (click)="itemClick(item)">\n      <ion-avatar item-start><img src={{item.pageImg}}/></ion-avatar>\n      <h2>{{item.pageName}}</h2>\n      <p text-wrap>{{item.content}}</p>\n    </ion-item>\n  </ion-list>\n\n  <ion-fab bottom right *ngIf="!registered">\n    <button ion-fab color="#FF1010" [disabled]="registered" (click)="linkPage()">\n      <ion-icon name="add"></ion-icon></button>\n  </ion-fab>\n</ion-content>\n'/*ion-inline-end:"C:\Users\fabia\Documents\Programmieren\Socify-Push\socify-push-app\SocifyPush\src\pages\about\about.html"*/
        }),
        __metadata("design:paramtypes", [__WEBPACK_IMPORTED_MODULE_1_ionic_angular__["f" /* Platform */], __WEBPACK_IMPORTED_MODULE_1_ionic_angular__["e" /* NavController */], __WEBPACK_IMPORTED_MODULE_1_ionic_angular__["a" /* AlertController */], __WEBPACK_IMPORTED_MODULE_1_ionic_angular__["h" /* ToastController */], __WEBPACK_IMPORTED_MODULE_2__ionic_native_http__["a" /* HTTP */], __WEBPACK_IMPORTED_MODULE_3__ionic_native_native_storage__["a" /* NativeStorage */]])
    ], AboutPage);
    return AboutPage;
}());

//# sourceMappingURL=about.js.map

/***/ }),

/***/ 202:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return HomePage; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_core__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_ionic_angular__ = __webpack_require__(15);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__scanner_scanner__ = __webpack_require__(102);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__ionic_native_http__ = __webpack_require__(41);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__ionic_native_native_storage__ = __webpack_require__(42);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5__ionic_native_in_app_browser__ = __webpack_require__(201);
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};









var HomePage = /** @class */ (function () {
    function HomePage(platform, navCtrl, alertCtrl, toastCtrl, http, nativeStorage) {
        this.platform = platform;
        this.navCtrl = navCtrl;
        this.alertCtrl = alertCtrl;
        this.toastCtrl = toastCtrl;
        this.http = http;
        this.nativeStorage = nativeStorage;
        this.registered = false;
        this.notifications = [
            {
                pageImg: "data:image/gif;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs=" /*base64 encoded blank gif*/,
                pageName: "Keine Nachrichten!",
                content: "Du hast leider noch keine Nachrichten"
            }
        ];
    }
    HomePage.prototype.ionViewWillEnter = function () {
        var _this = this;
        this.platform.ready().then(function () {
            if (_this.platform.is('cordova')) {
                _this.platform.resume.subscribe(function () {
                    _this.platform.ready().then(function () {
                        _this.refresherView._beginRefresh();
                        _this.nativeStorage.getItem("de.socify.push.TOKENS").then(function (data) {
                            var accessToken = data['access_token'];
                            var id = data['device_id'];
                            var userID = data['user_id'];
                            _this.notifications = data['notifications'];
                            var payload = {
                                device: {
                                    token: accessToken,
                                    id: id
                                },
                                user: {
                                    id: userID,
                                },
                            };
                            if (!accessToken || !id || !userID) {
                                _this.notifications = [
                                    {
                                        pageImg: "data:image/gif;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs=",
                                        pageName: "Bitte melde dich an!",
                                        content: "Tippe auf \"+\" um die App mit Socify zu verbinden. Bitte den QR code in deiner Socify-Instanz innerhalb deines Benutzerprofils aktivieren und mit der Kamera dieses Smartphones scannen."
                                    }
                                ];
                                _this.registered = false;
                                _this.refresherView.cancel();
                                return;
                            }
                            _this.notifications = data['notifications'];
                            _this.http.acceptAllCerts(false);
                            _this.http.enableSSLPinning(true);
                            _this.http.setDataSerializer('json');
                            _this.http.post("https://push.socify.de/getUserMessages", payload, null).then(function (res) {
                                var d = JSON.parse(res.data);
                                if (d.error) {
                                    _this.notifications = [
                                        {
                                            pageImg: "data:image/gif;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs=",
                                            pageName: "Bitte melde dich an!",
                                            content: "Tippe auf \"+\" um die App mit Socify zu verbinden. Bitte den QR code in deiner Socify-Instanz innerhalb deines Benutzerprofils aktivieren und mit der Kamera dieses Smartphones scannen."
                                        }
                                    ];
                                    _this.registered = false;
                                    _this.refresherView.cancel();
                                    return;
                                }
                                if (d.length > 0)
                                    _this.notifications = [];
                                console.log(d);
                                for (var _i = 0, d_1 = d; _i < d_1.length; _i++) {
                                    var message = d_1[_i];
                                    console.log(message);
                                    var m = {
                                        pageImg: "https://graph.facebook.com/v3.1/" + message['page_id'] + "/picture?size=large",
                                        pageName: message['page_name'],
                                        content: message['text'],
                                        url: message['url'],
                                        id: message['id'],
                                    };
                                    _this.notifications.push(m);
                                }
                                _this.nativeStorage.setItem("de.socify.push.TOKENS", {
                                    notifications: _this.notifications,
                                    access_token: accessToken,
                                    device_id: id,
                                    user_id: userID
                                });
                                _this.registered = true;
                                _this.refresherView.cancel();
                            }, function (err) {
                                var notTemp = _this.notifications;
                                _this.notifications = [
                                    {
                                        pageImg: "data:image/gif;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs=",
                                        pageName: "Netzwerkfehler!",
                                        content: "Bitte stelle sicher, dass eine Internetverbindung vorhanden ist!"
                                    }
                                ];
                                for (var _i = 0, notTemp_1 = notTemp; _i < notTemp_1.length; _i++) {
                                    var notification = notTemp_1[_i];
                                    _this.notifications.push(notification);
                                }
                                _this.refresherView.cancel();
                            });
                        }, function (err) {
                            _this.notifications = [
                                {
                                    pageImg: "data:image/gif;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs=",
                                    pageName: "Bitte melde dich an!",
                                    content: "Tippe auf \"+\" um die App mit Socify zu verbinden. Bitte den QR code in deiner Socify-Instanz innerhalb deines Benutzerprofils aktivieren und mit der Kamera dieses Smartphones scannen."
                                }
                            ];
                            _this.registered = false;
                            _this.refresherView.cancel();
                        });
                    });
                });
            }
            _this.nativeStorage.getItem("de.socify.push.TOKENS").then(function (data) {
                var accessToken = data['access_token'];
                var id = data['device_id'];
                var userID = data['user_id'];
                _this.notifications = data['notifications'];
                var payload = {
                    device: {
                        token: accessToken,
                        id: id
                    },
                    user: {
                        id: userID,
                    },
                };
                if (!accessToken || !id || !userID) {
                    _this.notifications = [
                        {
                            pageImg: "data:image/gif;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs=",
                            pageName: "Bitte melde dich an!",
                            content: "Tippe auf \"+\" um die App mit Socify zu verbinden. Bitte den QR code in deiner Socify-Instanz innerhalb deines Benutzerprofils aktivieren und mit der Kamera dieses Smartphones scannen."
                        }
                    ];
                    _this.registered = false;
                    return;
                }
                _this.notifications = data['notifications'];
                _this.http.acceptAllCerts(false);
                _this.http.enableSSLPinning(true);
                _this.http.setDataSerializer('json');
                _this.http.post("https://push.socify.de/getUserMessages", payload, null).then(function (res) {
                    var d = JSON.parse(res.data);
                    if (d.error) {
                        _this.notifications = [
                            {
                                pageImg: "data:image/gif;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs=",
                                pageName: "Bitte melde dich an!",
                                content: "Tippe auf \"+\" um die App mit Socify zu verbinden. Bitte den QR code in deiner Socify-Instanz innerhalb deines Benutzerprofils aktivieren und mit der Kamera dieses Smartphones scannen."
                            }
                        ];
                        _this.registered = false;
                        return;
                    }
                    if (d.length > 0)
                        _this.notifications = [];
                    console.log(d);
                    for (var _i = 0, d_2 = d; _i < d_2.length; _i++) {
                        var message = d_2[_i];
                        console.log(message);
                        var m = {
                            pageImg: "https://graph.facebook.com/v3.1/" + message['page_id'] + "/picture?size=large",
                            pageName: message['page_name'],
                            content: message['text'],
                            url: message['url'],
                            id: message['id'],
                        };
                        _this.notifications.push(m);
                    }
                    _this.registered = true;
                    _this.nativeStorage.setItem("de.socify.push.TOKENS", {
                        notifications: _this.notifications,
                        access_token: accessToken,
                        device_id: id,
                        user_id: userID
                    });
                }, function (err) {
                    var notTemp = _this.notifications;
                    _this.notifications = [
                        {
                            pageImg: "data:image/gif;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs=",
                            pageName: "Netzwerkfehler!",
                            content: "Bitte stelle sicher, dass eine Internetverbindung vorhanden ist!"
                        }
                    ];
                    for (var _i = 0, notTemp_2 = notTemp; _i < notTemp_2.length; _i++) {
                        var notification = notTemp_2[_i];
                        _this.notifications.push(notification);
                    }
                });
            }, function (err) {
                _this.notifications = [
                    {
                        pageImg: "data:image/gif;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs=",
                        pageName: "Bitte melde dich an!",
                        content: "Tippe auf \"+\" um die App mit Socify zu verbinden. Bitte den QR code in deiner Socify-Instanz innerhalb deines Benutzerprofils aktivieren und mit der Kamera dieses Smartphones scannen."
                    }
                ];
                _this.registered = false;
            });
        });
    };
    HomePage.prototype.hideCamera = function () {
        window.document.querySelector('ion-app').classList.remove('cameraView');
    };
    HomePage.prototype.ionViewDidEnter = function () {
        this.hideCamera();
    };
    HomePage.prototype.linkPage = function () {
        var _this = this;
        this.navCtrl.push(__WEBPACK_IMPORTED_MODULE_2__scanner_scanner__["a" /* ScannerPage */]).then(function () {
            _this.platform.ready().then(function () {
                _this.refresherView._beginRefresh();
                _this.nativeStorage.getItem("de.socify.push.TOKENS").then(function (data) {
                    var accessToken = data['access_token'];
                    var id = data['device_id'];
                    var userID = data['user_id'];
                    _this.notifications = data['notifications'];
                    var payload = {
                        device: {
                            token: accessToken,
                            id: id
                        },
                        user: {
                            id: userID,
                        },
                    };
                    if (!accessToken || !id || !userID) {
                        _this.notifications = [
                            {
                                pageImg: "data:image/gif;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs=",
                                pageName: "Bitte melde dich an!",
                                content: "Tippe auf \"+\" um die App mit Socify zu verbinden. Bitte den QR code in deiner Socify-Instanz innerhalb deines Benutzerprofils aktivieren und mit der Kamera dieses Smartphones scannen."
                            }
                        ];
                        _this.registered = false;
                        _this.refresherView.cancel();
                        return;
                    }
                    _this.notifications = data['notifications'];
                    _this.http.acceptAllCerts(false);
                    _this.http.enableSSLPinning(true);
                    _this.http.setDataSerializer('json');
                    _this.http.post("https://push.socify.de/getUserMessages", payload, null).then(function (res) {
                        var d = JSON.parse(res.data);
                        if (d.error) {
                            _this.notifications = [
                                {
                                    pageImg: "data:image/gif;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs=",
                                    pageName: "Bitte melde dich an!",
                                    content: "Tippe auf \"+\" um die App mit Socify zu verbinden. Bitte den QR code in deiner Socify-Instanz innerhalb deines Benutzerprofils aktivieren und mit der Kamera dieses Smartphones scannen."
                                }
                            ];
                            _this.registered = false;
                            _this.refresherView.cancel();
                            return;
                        }
                        if (d.length > 0)
                            _this.notifications = [];
                        console.log(d);
                        for (var _i = 0, d_3 = d; _i < d_3.length; _i++) {
                            var message = d_3[_i];
                            console.log(message);
                            var m = {
                                pageImg: "https://graph.facebook.com/v3.1/" + message['page_id'] + "/picture?size=large",
                                pageName: message['page_name'],
                                content: message['text'],
                                url: message['url'],
                                id: message['id'],
                            };
                            _this.notifications.push(m);
                        }
                        _this.nativeStorage.setItem("de.socify.push.TOKENS", {
                            notifications: _this.notifications,
                            access_token: accessToken,
                            device_id: id,
                            user_id: userID
                        });
                        _this.registered = true;
                        _this.refresherView.cancel();
                    }, function (err) {
                        var notTemp = _this.notifications;
                        _this.notifications = [
                            {
                                pageImg: "data:image/gif;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs=",
                                pageName: "Netzwerkfehler!",
                                content: "Bitte stelle sicher, dass eine Internetverbindung vorhanden ist!"
                            }
                        ];
                        for (var _i = 0, notTemp_3 = notTemp; _i < notTemp_3.length; _i++) {
                            var notification = notTemp_3[_i];
                            _this.notifications.push(notification);
                        }
                        _this.refresherView.cancel();
                    });
                }, function (err) {
                    _this.notifications = [
                        {
                            pageImg: "data:image/gif;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs=",
                            pageName: "Bitte melde dich an!",
                            content: "Tippe auf \"+\" um die App mit Socify zu verbinden. Bitte den QR code in deiner Socify-Instanz innerhalb deines Benutzerprofils aktivieren und mit der Kamera dieses Smartphones scannen."
                        }
                    ];
                    _this.registered = false;
                    _this.refresherView.cancel();
                });
            });
        });
    };
    HomePage.prototype.refresh = function (refresher) {
        var _this = this;
        this.nativeStorage.getItem("de.socify.push.TOKENS").then(function (data) {
            var accessToken = data['access_token'];
            var id = data['device_id'];
            var userID = data['user_id'];
            var payload = {
                device: {
                    token: accessToken,
                    id: id
                },
                user: {
                    id: userID,
                },
            };
            if (!accessToken || !id || !userID) {
                _this.notifications = [
                    {
                        pageImg: "data:image/gif;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs=",
                        pageName: "Bitte melde dich an!",
                        content: "Tippe auf \"+\" um die App mit Socify zu verbinden. Bitte den QR code in deiner Socify-Instanz innerhalb deines Benutzerprofils aktivieren und mit der Kamera dieses Smartphones scannen."
                    }
                ];
                refresher.complete();
                return;
            }
            _this.notifications = data['notifications'];
            _this.http.acceptAllCerts(false);
            _this.http.enableSSLPinning(true);
            _this.http.setDataSerializer('json');
            _this.http.post("https://push.socify.de/getUserMessages", payload, null).then(function (res) {
                var d = JSON.parse(res.data);
                if (d.error) {
                    _this.notifications = [
                        {
                            pageImg: "data:image/gif;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs=",
                            pageName: "Bitte melde dich an!",
                            content: "Tippe auf \"+\" um die App mit Socify zu verbinden. Bitte den QR code in deiner Socify-Instanz innerhalb deines Benutzerprofils aktivieren und mit der Kamera dieses Smartphones scannen."
                        }
                    ];
                    _this.registered = false;
                    refresher.complete();
                    return;
                }
                _this.notifications = [];
                console.log(d);
                for (var _i = 0, d_4 = d; _i < d_4.length; _i++) {
                    var message = d_4[_i];
                    console.log(message);
                    var m = {
                        pageImg: "https://graph.facebook.com/v3.1/" + message['page_id'] + "/picture?size=large",
                        pageName: message['page_name'],
                        content: message['text'],
                        url: message['url'],
                        id: message['id'],
                    };
                    _this.notifications.push(m);
                }
                refresher.complete();
                _this.nativeStorage.setItem("de.socify.push.TOKENS", {
                    notifications: _this.notifications,
                    access_token: accessToken,
                    device_id: id,
                    user_id: userID
                });
                _this.registered = true;
            }, function (err) {
                var notTemp = _this.notifications;
                _this.notifications = [
                    {
                        pageImg: "data:image/gif;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs=",
                        pageName: "Netzwerkfehler!",
                        content: "Bitte stelle sicher, dass eine Internetverbindung vorhanden ist!"
                    }
                ];
                for (var _i = 0, notTemp_4 = notTemp; _i < notTemp_4.length; _i++) {
                    var notification = notTemp_4[_i];
                    _this.notifications.push(notification);
                }
                refresher.complete();
            });
        }, function (err) {
            _this.notifications = [
                {
                    pageImg: "data:image/gif;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs=",
                    pageName: "Bitte melde dich an!",
                    content: "Tippe auf \"+\" um die App mit Socify zu verbinden. Bitte den QR code in deiner Socify-Instanz innerhalb deines Benutzerprofils aktivieren und mit der Kamera dieses Smartphones scannen."
                }
            ];
            _this.registered = false;
        });
    };
    HomePage.prototype.itemClick = function (item) {
        if (item.url)
            new __WEBPACK_IMPORTED_MODULE_5__ionic_native_in_app_browser__["a" /* InAppBrowser */]().create(item.url, '_system');
    };
    HomePage.prototype.archive = function (item, slidingItem) {
        var _this = this;
        if (item.id) {
            this.nativeStorage.getItem("de.socify.push.TOKENS").then(function (data) {
                var accessToken = data['access_token'];
                var id = data['device_id'];
                var userID = data['user_id'];
                var payload = {
                    device: {
                        token: accessToken,
                        id: id
                    },
                    user: {
                        id: userID,
                    },
                    message: {
                        id: item.id,
                    }
                };
                _this.http.acceptAllCerts(false);
                _this.http.enableSSLPinning(true);
                _this.http.setDataSerializer('json');
                _this.http.post("https://push.socify.de/markAsRead", payload, null).then(function (res) {
                    var d = JSON.parse(res.data);
                    console.log('archive: ' + res.data);
                    for (var i = 0; i < _this.notifications.length; i++) {
                        if (_this.notifications[i] == item) {
                            console.log('found item!');
                            slidingItem.close();
                            _this.notifications.splice(i, 1);
                        }
                    }
                });
            });
        }
    };
    __decorate([
        Object(__WEBPACK_IMPORTED_MODULE_0__angular_core__["_8" /* ViewChild */])(__WEBPACK_IMPORTED_MODULE_1_ionic_angular__["g" /* Refresher */]),
        __metadata("design:type", __WEBPACK_IMPORTED_MODULE_1_ionic_angular__["g" /* Refresher */])
    ], HomePage.prototype, "refresherView", void 0);
    HomePage = __decorate([
        Object(__WEBPACK_IMPORTED_MODULE_0__angular_core__["m" /* Component */])({
            selector: 'page-home',template:/*ion-inline-start:"C:\Users\fabia\Documents\Programmieren\Socify-Push\socify-push-app\SocifyPush\src\pages\home\home.html"*/'<ion-header>\n  <ion-navbar>\n    <ion-title>Home</ion-title>\n  </ion-navbar>\n</ion-header>\n\n<ion-content padding>\n  <ion-refresher (ionRefresh)="refresh($event)">\n    <ion-refresher-content></ion-refresher-content>\n  </ion-refresher>\n  <h2>Benachrichtigungen:</h2>\n <ion-list>\n   <ion-item-sliding *ngFor="let item of notifications" #slidingItem>\n     <ion-item (click)="itemClick(item)">\n       <ion-avatar item-start><img src={{item.pageImg}}/></ion-avatar>\n       <h2>{{item.pageName}}</h2>\n       <p text-wrap>{{item.content}}</p>\n     </ion-item>\n     <ion-item-options side="left">\n       <button ion-button (click)="archive(item, slidingItem)">\n         <ion-icon name="archive"></ion-icon>\n         Archivieren\n       </button>\n     </ion-item-options>\n   </ion-item-sliding>\n </ion-list>\n\n  <ion-fab bottom right *ngIf="!registered">\n    <button ion-fab color="#FF1010" [disabled]="registered" (click)="linkPage()">\n      <ion-icon name="add"></ion-icon></button>\n  </ion-fab>\n</ion-content>\n'/*ion-inline-end:"C:\Users\fabia\Documents\Programmieren\Socify-Push\socify-push-app\SocifyPush\src\pages\home\home.html"*/
        }),
        __metadata("design:paramtypes", [__WEBPACK_IMPORTED_MODULE_1_ionic_angular__["f" /* Platform */], __WEBPACK_IMPORTED_MODULE_1_ionic_angular__["e" /* NavController */], __WEBPACK_IMPORTED_MODULE_1_ionic_angular__["a" /* AlertController */], __WEBPACK_IMPORTED_MODULE_1_ionic_angular__["h" /* ToastController */], __WEBPACK_IMPORTED_MODULE_3__ionic_native_http__["a" /* HTTP */], __WEBPACK_IMPORTED_MODULE_4__ionic_native_native_storage__["a" /* NativeStorage */]])
    ], HomePage);
    return HomePage;
}());

//# sourceMappingURL=home.js.map

/***/ }),

/***/ 203:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_platform_browser_dynamic__ = __webpack_require__(204);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__app_module__ = __webpack_require__(226);


Object(__WEBPACK_IMPORTED_MODULE_0__angular_platform_browser_dynamic__["a" /* platformBrowserDynamic */])().bootstrapModule(__WEBPACK_IMPORTED_MODULE_1__app_module__["a" /* AppModule */]);
//# sourceMappingURL=main.js.map

/***/ }),

/***/ 226:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return AppModule; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_core__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__angular_platform_browser__ = __webpack_require__(32);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_ionic_angular__ = __webpack_require__(15);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__app_component__ = __webpack_require__(269);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__pages_about_about__ = __webpack_require__(198);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5__pages_home_home__ = __webpack_require__(202);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6__pages_tabs_tabs__ = __webpack_require__(197);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7__pages_scanner_scanner__ = __webpack_require__(102);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8__ionic_native_status_bar__ = __webpack_require__(194);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_9__ionic_native_splash_screen__ = __webpack_require__(196);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_10__ionic_native_qr_scanner__ = __webpack_require__(199);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_11__ionic_native_http__ = __webpack_require__(41);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_12__ionic_native_fcm__ = __webpack_require__(103);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_13__ionic_native_device__ = __webpack_require__(200);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_14__ionic_native_native_storage__ = __webpack_require__(42);
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};















var AppModule = /** @class */ (function () {
    function AppModule() {
    }
    AppModule = __decorate([
        Object(__WEBPACK_IMPORTED_MODULE_0__angular_core__["I" /* NgModule */])({
            declarations: [
                __WEBPACK_IMPORTED_MODULE_3__app_component__["a" /* MyApp */],
                __WEBPACK_IMPORTED_MODULE_4__pages_about_about__["a" /* AboutPage */],
                __WEBPACK_IMPORTED_MODULE_5__pages_home_home__["a" /* HomePage */],
                __WEBPACK_IMPORTED_MODULE_6__pages_tabs_tabs__["a" /* TabsPage */],
                __WEBPACK_IMPORTED_MODULE_7__pages_scanner_scanner__["a" /* ScannerPage */]
            ],
            imports: [
                __WEBPACK_IMPORTED_MODULE_1__angular_platform_browser__["a" /* BrowserModule */],
                __WEBPACK_IMPORTED_MODULE_2_ionic_angular__["d" /* IonicModule */].forRoot(__WEBPACK_IMPORTED_MODULE_3__app_component__["a" /* MyApp */], {}, {
                    links: []
                })
            ],
            bootstrap: [__WEBPACK_IMPORTED_MODULE_2_ionic_angular__["b" /* IonicApp */]],
            entryComponents: [
                __WEBPACK_IMPORTED_MODULE_3__app_component__["a" /* MyApp */],
                __WEBPACK_IMPORTED_MODULE_4__pages_about_about__["a" /* AboutPage */],
                __WEBPACK_IMPORTED_MODULE_5__pages_home_home__["a" /* HomePage */],
                __WEBPACK_IMPORTED_MODULE_6__pages_tabs_tabs__["a" /* TabsPage */],
                __WEBPACK_IMPORTED_MODULE_7__pages_scanner_scanner__["a" /* ScannerPage */]
            ],
            providers: [
                __WEBPACK_IMPORTED_MODULE_8__ionic_native_status_bar__["a" /* StatusBar */],
                __WEBPACK_IMPORTED_MODULE_9__ionic_native_splash_screen__["a" /* SplashScreen */],
                __WEBPACK_IMPORTED_MODULE_10__ionic_native_qr_scanner__["a" /* QRScanner */],
                __WEBPACK_IMPORTED_MODULE_11__ionic_native_http__["a" /* HTTP */],
                __WEBPACK_IMPORTED_MODULE_12__ionic_native_fcm__["a" /* FCM */],
                __WEBPACK_IMPORTED_MODULE_13__ionic_native_device__["a" /* Device */],
                __WEBPACK_IMPORTED_MODULE_14__ionic_native_native_storage__["a" /* NativeStorage */],
                { provide: __WEBPACK_IMPORTED_MODULE_0__angular_core__["u" /* ErrorHandler */], useClass: __WEBPACK_IMPORTED_MODULE_2_ionic_angular__["c" /* IonicErrorHandler */] }
            ]
        })
    ], AppModule);
    return AppModule;
}());

//# sourceMappingURL=app.module.js.map

/***/ }),

/***/ 269:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return MyApp; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_core__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_ionic_angular__ = __webpack_require__(15);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__ionic_native_status_bar__ = __webpack_require__(194);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__ionic_native_splash_screen__ = __webpack_require__(196);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__pages_tabs_tabs__ = __webpack_require__(197);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5__ionic_native_fcm__ = __webpack_require__(103);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6__ionic_native_http__ = __webpack_require__(41);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7__ionic_native_native_storage__ = __webpack_require__(42);
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};








var MyApp = /** @class */ (function () {
    function MyApp(platform, statusBar, splashScreen, fcm, http, nativeStorage) {
        var _this = this;
        this.fcm = fcm;
        this.http = http;
        this.nativeStorage = nativeStorage;
        this.rootPage = __WEBPACK_IMPORTED_MODULE_4__pages_tabs_tabs__["a" /* TabsPage */];
        platform.ready().then(function () {
            // Okay, so the platform is ready and our plugins are available.
            // Here you can do any higher level native things you might need.
            statusBar.styleDefault();
            splashScreen.hide();
            fcm.onNotification().subscribe(function (data) {
                console.log(data);
                if (!data.wasTapped) {
                }
            });
            fcm.onTokenRefresh().subscribe(function (token) {
                //Do token refresh shit here
                _this.nativeStorage.getItem("de.socify.push.TOKENS").then(function (data) {
                    var accessToken = data['access_token'];
                    var id = data['device_id'];
                    var userID = data['user_id'];
                    var payload = {
                        device: {
                            notify_key: token,
                            device_token: accessToken,
                            id: id
                        },
                        user: {
                            id: userID,
                        },
                    };
                    _this.http.acceptAllCerts(false);
                    _this.http.enableSSLPinning(true);
                    _this.http.setDataSerializer('json');
                    _this.http.post("https://push.socify-lite.de/registerDevice", payload, null).then(function (res) {
                        var accessToken = res.data.access_token;
                        var device_id = res.data.id;
                        _this.nativeStorage.setItem('de.socify.push.TOKENS', { access_token: accessToken, device_id: device_id, user_id: userID });
                    });
                });
            });
        });
    }
    MyApp = __decorate([
        Object(__WEBPACK_IMPORTED_MODULE_0__angular_core__["m" /* Component */])({template:/*ion-inline-start:"C:\Users\fabia\Documents\Programmieren\Socify-Push\socify-push-app\SocifyPush\src\app\app.html"*/'<ion-nav [root]="rootPage"></ion-nav>\n'/*ion-inline-end:"C:\Users\fabia\Documents\Programmieren\Socify-Push\socify-push-app\SocifyPush\src\app\app.html"*/
        }),
        __metadata("design:paramtypes", [__WEBPACK_IMPORTED_MODULE_1_ionic_angular__["f" /* Platform */], __WEBPACK_IMPORTED_MODULE_2__ionic_native_status_bar__["a" /* StatusBar */], __WEBPACK_IMPORTED_MODULE_3__ionic_native_splash_screen__["a" /* SplashScreen */], __WEBPACK_IMPORTED_MODULE_5__ionic_native_fcm__["a" /* FCM */], __WEBPACK_IMPORTED_MODULE_6__ionic_native_http__["a" /* HTTP */], __WEBPACK_IMPORTED_MODULE_7__ionic_native_native_storage__["a" /* NativeStorage */]])
    ], MyApp);
    return MyApp;
}());

//# sourceMappingURL=app.component.js.map

/***/ })

},[203]);
//# sourceMappingURL=main.js.map